%Script confronto metodi inversione matrice least-squares
%Scritto da Pavan Andrea - 22/07/2022
clear;
clc;


%% dati input
l1 = 0.1;        %lunghezza lato x [m]
l2 = 0.1;        %lunghezza lato y [m]
nEdgePoints = 30;       %numero punti in ciascun lato
searchdist = l1/10;      %distanza ricerca punti
Nminsat = 8;        %numero minimo satelliti


%% generazione pointcloud
boundaryNodes = [linspace(0,l1,nEdgePoints)', 0*ones(nEdgePoints,1);
    l1+0*ones(nEdgePoints,1), linspace(0,l2,nEdgePoints)';
    fliplr(linspace(0,l1,nEdgePoints))', l2+0*ones(nEdgePoints,1);
    0*ones(nEdgePoints,1), fliplr(linspace(0,l2,nEdgePoints))'];
boundaryNodes = unique(boundaryNodes,'rows','stable');      %punti contorno
P = generate_pointcloud(boundaryNodes,'nextrasteps',0,'lmax',0.1);
P = [boundaryNodes; P];


%% popolamento stelle
Psatidx = [];        %elenco punti satellite
Nsat = zeros(length(P),1);      %numero punti satellite
for i=1:length(P)
    %cerco i satelliti del punto i
    searchdisti = searchdist;
    while Nsat(i)<Nminsat
        Psatidx{i} = find((abs(P(:,1)-P(i,1))<=searchdisti).*(abs(P(:,2)-P(i,2))<=searchdisti));
        Nsat(i) = length(Psatidx{i});
        searchdisti = searchdisti*1.1;
    end
end

%calcolo distanze satelliti
h = [];     %distanza x satelliti
k = [];     %distanza y satelliti
for i=1:length(P)
    h{i} = zeros(Nsat(i),1);
    k{i} = zeros(Nsat(i),1);
    for j=1:Nsat(i)
        h{i}(j) = P(Psatidx{i}(j),1)-P(i,1);
        k{i}(j) = P(Psatidx{i}(j),2)-P(i,2);
    end
end

%calcolo pesi satelliti
w2 = [];
for i=1:length(P)
    R2 = h{i}.^2+k{i}.^2;
    R2max = max(R2);
    w2{i} = exp(-1*R2/R2max).^2;
    %w2{i} = 1 - 6*(R2/R2max).^2 + 8*(R2/R2max).^3 - 3*(R2/R2max).^4;
end


%% inversione matrici minimi quadrati - approccio numerico
T1 = clock;
invA = [];      %matrici minimi quadrati invertite
condA = zeros(length(P),1);     %numero condizionamento matrici
for i=1:length(P)
    A = [sum(h{i}.^2.*w2{i}), sum(h{i}.*k{i}.*w2{i}), 0.5*sum(h{i}.^3.*w2{i}), 0.5*sum(h{i}.*k{i}.^2.*w2{i}), sum(h{i}.^2.*k{i}.*w2{i});
        sum(h{i}.*k{i}.*w2{i}), sum(k{i}.^2.*w2{i}), 0.5*sum(h{i}.^2.*k{i}.*w2{i}), 0.5*sum(k{i}.^3.*w2{i}), sum(h{i}.*k{i}.^2.*w2{i});
        0.5*sum(h{i}.^3.*w2{i}), 0.5*sum(h{i}.^2.*k{i}.*w2{i}), 0.25*sum(h{i}.^4.*w2{i}), 0.25*sum(h{i}.^2.*k{i}.^2.*w2{i}), 0.5*sum(h{i}.^3.*k{i}.*w2{i});
        0.5*sum(h{i}.*k{i}.^2.*w2{i}), 0.5*sum(k{i}.^3.*w2{i}), 0.25*sum(h{i}.^2.*k{i}.^2.*w2{i}), 0.25*sum(k{i}.^4.*w2{i}), 0.5*sum(h{i}.*k{i}.^3.*w2{i});
        sum(h{i}.^2.*k{i}.*w2{i}), sum(h{i}.*k{i}.^2.*w2{i}), 0.5*sum(h{i}.^3.*k{i}.*w2{i}), 0.5*sum(h{i}.*k{i}.^3.*w2{i}), sum(h{i}.^2.*k{i}.^2.*w2{i})];
    invA{i} = inv(A);
    condA(i) = cond(A);
end
time1 = etime(clock,T1);


%% inversione matrici minimi quadrati - approccio analitico
T2 = clock;
invAsym = [];     %matrici minimi quadrati invertite
a11 = 0;
a12 = 0;
a13 = 0;
a14 = 0;
a15 = 0;
a22 = 0;
a23 = 0;
a24 = 0;
a25 = 0;
a33 = 0;
a34 = 0;
a35 = 0;
a44 = 0;
a45 = 0;
a55 = 0;
den = 0;
for i=1:length(P)
    a11 = sum(h{i}.^2.*w2{i});
    a12 = sum(h{i}.*k{i}.*w2{i});
    a13 = 0.5*sum(h{i}.^3.*w2{i});
    a14 = 0.5*sum(h{i}.*k{i}.^2.*w2{i});
    a15 = sum(h{i}.^2.*k{i}.*w2{i});
    a22 = sum(k{i}.^2.*w2{i});
    a23 = 0.5*sum(h{i}.^2.*k{i}.*w2{i});
    a24 = 0.5*sum(k{i}.^3.*w2{i});
    a25 = sum(h{i}.*k{i}.^2.*w2{i});
    a33 = 0.25*sum(h{i}.^4.*w2{i});
    a34 = 0.25*sum(h{i}.^2.*k{i}.^2.*w2{i});
    a35 = 0.5*sum(h{i}.^3.*k{i}.*w2{i});
    a44 = 0.25*sum(k{i}.^4.*w2{i});
    a45 = 0.5*sum(h{i}.*k{i}.^3.*w2{i});
    a55 = sum(h{i}.^2.*k{i}.^2.*w2{i});
    den = (a55*a12^2*a34^2 - 2*a12^2*a34*a35*a45 + a44*a12^2*a35^2 + a33*a12^2*a45^2 - a33*a44*a55*a12^2 - 2*a12*a13*a23*a45^2 + 2*a44*a55*a12*a13*a23 - 2*a55*a12*a13*a24*a34 + 2*a12*a13*a24*a35*a45 + 2*a12*a13*a25*a34*a45 - 2*a44*a12*a13*a25*a35 - 2*a55*a12*a14*a23*a34 + 2*a12*a14*a23*a35*a45 - 2*a12*a14*a24*a35^2 + 2*a33*a55*a12*a14*a24 + 2*a12*a14*a25*a34*a35 - 2*a33*a12*a14*a25*a45 + 2*a12*a15*a23*a34*a45 - 2*a44*a12*a15*a23*a35 + 2*a12*a15*a24*a34*a35 - 2*a33*a12*a15*a24*a45 - 2*a12*a15*a25*a34^2 + 2*a33*a44*a12*a15*a25 + a55*a13^2*a24^2 - 2*a13^2*a24*a25*a45 + a44*a13^2*a25^2 + a22*a13^2*a45^2 - a22*a44*a55*a13^2 - 2*a55*a13*a14*a23*a24 + 2*a13*a14*a23*a25*a45 + 2*a13*a14*a24*a25*a35 - 2*a13*a14*a25^2*a34 + 2*a22*a55*a13*a14*a34 - 2*a22*a13*a14*a35*a45 + 2*a13*a15*a23*a24*a45 - 2*a44*a13*a15*a23*a25 - 2*a13*a15*a24^2*a35 + 2*a13*a15*a24*a25*a34 - 2*a22*a13*a15*a34*a45 + 2*a22*a44*a13*a15*a35 + a55*a14^2*a23^2 - 2*a14^2*a23*a25*a35 + a33*a14^2*a25^2 + a22*a14^2*a35^2 - a22*a33*a55*a14^2 - 2*a14*a15*a23^2*a45 + 2*a14*a15*a23*a24*a35 + 2*a14*a15*a23*a25*a34 - 2*a33*a14*a15*a24*a25 - 2*a22*a14*a15*a34*a35 + 2*a22*a33*a14*a15*a45 + a44*a15^2*a23^2 - 2*a15^2*a23*a24*a34 + a33*a15^2*a24^2 + a22*a15^2*a34^2 - a22*a33*a44*a15^2 + a11*a23^2*a45^2 - a11*a44*a55*a23^2 + 2*a11*a55*a23*a24*a34 - 2*a11*a23*a24*a35*a45 - 2*a11*a23*a25*a34*a45 + 2*a11*a44*a23*a25*a35 + a11*a24^2*a35^2 - a11*a33*a55*a24^2 - 2*a11*a24*a25*a34*a35 + 2*a11*a33*a24*a25*a45 + a11*a25^2*a34^2 - a11*a33*a44*a25^2 - a11*a22*a55*a34^2 + 2*a11*a22*a34*a35*a45 - a11*a22*a44*a35^2 - a11*a22*a33*a45^2 + a11*a22*a33*a44*a55);

    invAsym{i} = zeros(5,5);
    invAsym{i}(1,1) = -(- a23^2*a45^2 + a44*a55*a23^2 - 2*a55*a23*a24*a34 + 2*a23*a24*a35*a45 + 2*a23*a25*a34*a45 - 2*a44*a23*a25*a35 - a24^2*a35^2 + a33*a55*a24^2 + 2*a24*a25*a34*a35 - 2*a33*a24*a25*a45 - a25^2*a34^2 + a33*a44*a25^2 + a22*a55*a34^2 - 2*a22*a34*a35*a45 + a22*a44*a35^2 + a22*a33*a45^2 - a22*a33*a44*a55)/den;
    invAsym{i}(1,2) = (a12*a33*a45^2 - a14*a24*a35^2 - a15*a25*a34^2 - a13*a23*a45^2 + a12*a35^2*a44 + a12*a34^2*a55 + a15*a24*a34*a35 - a13*a24*a34*a55 + a13*a24*a35*a45 - a14*a23*a34*a55 + a14*a23*a35*a45 + a14*a24*a33*a55 + a15*a23*a34*a45 - a15*a23*a35*a44 - a15*a24*a33*a45 + a13*a23*a44*a55 + a14*a25*a34*a35 + a13*a25*a34*a45 - a13*a25*a35*a44 - a14*a25*a33*a45 + a15*a25*a33*a44 - 2*a12*a34*a35*a45 - a12*a33*a44*a55)/den;
    invAsym{i}(1,3) = (a13*a22*a45^2 - a12*a23*a45^2 - a15*a24^2*a35 + a13*a24^2*a55 - a14*a25^2*a34 + a13*a25^2*a44 - a14*a23*a24*a55 + a15*a23*a24*a45 + a14*a24*a25*a35 + a15*a24*a25*a34 - 2*a13*a24*a25*a45 + a14*a23*a25*a45 - a15*a23*a25*a44 - a12*a24*a34*a55 + a12*a24*a35*a45 + a14*a22*a34*a55 - a14*a22*a35*a45 - a15*a22*a34*a45 + a15*a22*a35*a44 + a12*a23*a44*a55 - a13*a22*a44*a55 + a12*a25*a34*a45 - a12*a25*a35*a44)/den;
    invAsym{i}(1,4) = (a14*a22*a35^2 - a12*a24*a35^2 - a13*a25^2*a34 + a14*a25^2*a33 + a14*a23^2*a55 - a15*a23^2*a45 + a15*a23*a24*a35 - a13*a23*a24*a55 + a13*a24*a25*a35 - 2*a14*a23*a25*a35 + a15*a23*a25*a34 - a15*a24*a25*a33 + a13*a23*a25*a45 - a15*a22*a34*a35 - a12*a23*a34*a55 + a12*a23*a35*a45 + a12*a24*a33*a55 + a13*a22*a34*a55 - a13*a22*a35*a45 - a14*a22*a33*a55 + a15*a22*a33*a45 + a12*a25*a34*a35 - a12*a25*a33*a45)/den;
    invAsym{i}(1,5) = (a15*a22*a34^2 - a13*a24^2*a35 + a15*a24^2*a33 - a12*a25*a34^2 - a14*a23^2*a45 + a15*a23^2*a44 + a14*a23*a24*a35 - 2*a15*a23*a24*a34 + a13*a23*a24*a45 + a13*a24*a25*a34 + a14*a23*a25*a34 - a14*a24*a25*a33 - a13*a23*a25*a44 + a12*a24*a34*a35 - a14*a22*a34*a35 + a12*a23*a34*a45 - a12*a23*a35*a44 - a12*a24*a33*a45 - a13*a22*a34*a45 + a13*a22*a35*a44 + a14*a22*a33*a45 - a15*a22*a33*a44 + a12*a25*a33*a44)/den;
    invAsym{i}(2,1) = invAsym{i}(1,2);
    invAsym{i}(2,2) = -(- a13^2*a45^2 + a44*a55*a13^2 - 2*a55*a13*a14*a34 + 2*a13*a14*a35*a45 + 2*a13*a15*a34*a45 - 2*a44*a13*a15*a35 - a14^2*a35^2 + a33*a55*a14^2 + 2*a14*a15*a34*a35 - 2*a33*a14*a15*a45 - a15^2*a34^2 + a33*a44*a15^2 + a11*a55*a34^2 - 2*a11*a34*a35*a45 + a11*a44*a35^2 + a11*a33*a45^2 - a11*a33*a44*a55)/den;
    invAsym{i}(2,3) = (a11*a23*a45^2 - a12*a13*a45^2 - a15^2*a24*a34 + a15^2*a23*a44 + a14^2*a23*a55 - a14^2*a25*a35 + a14*a15*a25*a34 + a13*a14*a25*a45 - a13*a15*a25*a44 - a12*a14*a34*a55 + a12*a14*a35*a45 + a12*a15*a34*a45 - a12*a15*a35*a44 + a12*a13*a44*a55 + a11*a24*a34*a55 - a11*a24*a35*a45 - a11*a23*a44*a55 - a11*a25*a34*a45 + a11*a25*a35*a44 + a14*a15*a24*a35 - a13*a14*a24*a55 + a13*a15*a24*a45 - 2*a14*a15*a23*a45)/den;
    invAsym{i}(2,4) = (a11*a24*a35^2 - a12*a14*a35^2 - a15^2*a23*a34 + a15^2*a24*a33 + a13^2*a24*a55 - a13^2*a25*a45 + a12*a15*a34*a35 - a12*a13*a34*a55 + a12*a13*a35*a45 + a12*a14*a33*a55 - a12*a15*a33*a45 + a11*a23*a34*a55 - a11*a23*a35*a45 - a11*a24*a33*a55 - a11*a25*a34*a35 + a11*a25*a33*a45 - 2*a13*a15*a24*a35 + a14*a15*a23*a35 - a13*a14*a23*a55 + a13*a15*a23*a45 + a13*a14*a25*a35 + a13*a15*a25*a34 - a14*a15*a25*a33)/den;
    invAsym{i}(2,5) = (a11*a25*a34^2 - a12*a15*a34^2 - a14^2*a23*a35 - a13^2*a24*a45 + a14^2*a25*a33 + a13^2*a25*a44 + a12*a14*a34*a35 + a12*a13*a34*a45 - a12*a13*a35*a44 - a12*a14*a33*a45 + a12*a15*a33*a44 - a11*a24*a34*a35 - a11*a23*a34*a45 + a11*a23*a35*a44 + a11*a24*a33*a45 - a11*a25*a33*a44 + a13*a14*a24*a35 + a13*a15*a24*a34 + a14*a15*a23*a34 - a14*a15*a24*a33 + a13*a14*a23*a45 - a13*a15*a23*a44 - 2*a13*a14*a25*a34)/den;
    invAsym{i}(3,1) = invAsym{i}(1,3);
    invAsym{i}(3,2) = invAsym{i}(2,3);
    invAsym{i}(3,3) = -(- a12^2*a45^2 + a44*a55*a12^2 - 2*a55*a12*a14*a24 + 2*a12*a14*a25*a45 + 2*a12*a15*a24*a45 - 2*a44*a12*a15*a25 - a14^2*a25^2 + a22*a55*a14^2 + 2*a14*a15*a24*a25 - 2*a22*a14*a15*a45 - a15^2*a24^2 + a22*a44*a15^2 + a11*a55*a24^2 - 2*a11*a24*a25*a45 + a11*a44*a25^2 + a11*a22*a45^2 - a11*a22*a44*a55)/den;
    invAsym{i}(3,4) = (a15^2*a22*a34 - a15^2*a23*a24 - a13*a14*a25^2 + a11*a25^2*a34 + a12^2*a34*a55 - a12^2*a35*a45 + a11*a23*a24*a55 - a11*a24*a25*a35 - a11*a23*a25*a45 - a11*a22*a34*a55 + a11*a22*a35*a45 + a13*a15*a24*a25 + a14*a15*a23*a25 + a12*a15*a24*a35 - a14*a15*a22*a35 - a12*a13*a24*a55 - a12*a14*a23*a55 + a12*a15*a23*a45 + a13*a14*a22*a55 - a13*a15*a22*a45 + a12*a14*a25*a35 - 2*a12*a15*a25*a34 + a12*a13*a25*a45)/den;
    invAsym{i}(3,5) = (a11*a24^2*a35 - a14^2*a23*a25 - a13*a15*a24^2 + a14^2*a22*a35 - a12^2*a34*a45 + a12^2*a35*a44 - a11*a24*a25*a34 + a11*a23*a25*a44 + a11*a22*a34*a45 - a11*a22*a35*a44 + a14*a15*a23*a24 + a13*a14*a24*a25 - 2*a12*a14*a24*a35 + a12*a15*a24*a34 - a14*a15*a22*a34 + a12*a13*a24*a45 + a12*a14*a23*a45 - a12*a15*a23*a44 - a13*a14*a22*a45 + a13*a15*a22*a44 + a12*a14*a25*a34 - a12*a13*a25*a44 - a11*a23*a24*a45)/den;
    invAsym{i}(4,1) = invAsym{i}(1,4);
    invAsym{i}(4,2) = invAsym{i}(2,4);
    invAsym{i}(4,3) = invAsym{i}(3,4);
    invAsym{i}(4,4) = -(- a12^2*a35^2 + a33*a55*a12^2 - 2*a55*a12*a13*a23 + 2*a12*a13*a25*a35 + 2*a12*a15*a23*a35 - 2*a33*a12*a15*a25 - a13^2*a25^2 + a22*a55*a13^2 + 2*a13*a15*a23*a25 - 2*a22*a13*a15*a35 - a15^2*a23^2 + a22*a33*a15^2 + a11*a55*a23^2 - 2*a11*a23*a25*a35 + a11*a33*a25^2 + a11*a22*a35^2 - a11*a22*a33*a55)/den;
    invAsym{i}(4,5) = (a11*a23^2*a45 - a13^2*a24*a25 - a14*a15*a23^2 + a13^2*a22*a45 - a12^2*a34*a35 + a12^2*a33*a45 + a11*a22*a34*a35 - a11*a22*a33*a45 + a13*a15*a23*a24 + a13*a14*a23*a25 + a12*a13*a24*a35 + a12*a14*a23*a35 + a12*a15*a23*a34 - a12*a15*a24*a33 - a13*a14*a22*a35 - a13*a15*a22*a34 + a14*a15*a22*a33 - 2*a12*a13*a23*a45 + a12*a13*a25*a34 - a12*a14*a25*a33 - a11*a23*a24*a35 - a11*a23*a25*a34 + a11*a24*a25*a33)/den;
    invAsym{i}(5,1) = invAsym{i}(1,5);
    invAsym{i}(5,2) = invAsym{i}(2,5);
    invAsym{i}(5,3) = invAsym{i}(3,5);
    invAsym{i}(5,4) = invAsym{i}(4,5);
    invAsym{i}(5,5) = -(- a12^2*a34^2 + a33*a44*a12^2 - 2*a44*a12*a13*a23 + 2*a12*a13*a24*a34 + 2*a12*a14*a23*a34 - 2*a33*a12*a14*a24 - a13^2*a24^2 + a22*a44*a13^2 + 2*a13*a14*a23*a24 - 2*a22*a13*a14*a34 - a14^2*a23^2 + a22*a33*a14^2 + a11*a44*a23^2 - 2*a11*a23*a24*a34 + a11*a33*a24^2 + a11*a22*a34^2 - a11*a22*a33*a44)/den;
end
time2 = etime(clock,T2);

fprintf('Tempo approccio numerico: %.3f s\n',time1);
fprintf('Tempo approccio analitico: %.3f s\n',time2);


